/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWEventDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFaultDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWSimpleInstruction;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWFunctionStrings;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWPrinter;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWPrintableProperty;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class VWPrintableStepProperty
extends VWPrintableProperty {
    protected static final Image START_DUMMY_STEP_ICON = VWImageLoader.createImageIcon("dummystep_st.gif").getImage();
    protected static final Image DUMMY_STEP_ICON = VWImageLoader.createImageIcon("dummystep_f.gif").getImage();
    protected static final Image START_USER_STEP_ICON = VWImageLoader.createImageIcon("userstep_st.gif").getImage();
    protected static final Image USER_STEP_ICON = VWImageLoader.createImageIcon("userstep_f.gif").getImage();
    protected static final Image START_QUEUE_STEP_ICON = VWImageLoader.createImageIcon("queuestep_st.gif").getImage();
    protected static final Image QUEUE_STEP_ICON = VWImageLoader.createImageIcon("queuestep_f.gif").getImage();
    protected static final Image START_COMPONENT_STEP_ICON = VWImageLoader.createImageIcon("componentstep_st.gif").getImage();
    protected static final Image COMPONENT_STEP_ICON = VWImageLoader.createImageIcon("componentstep_f.gif").getImage();
    protected static final Image START_CALL_STEP_ICON = VWImageLoader.createImageIcon("callstep_st.gif").getImage();
    protected static final Image CALL_STEP_ICON = VWImageLoader.createImageIcon("callstep_f.gif").getImage();
    protected static final Image START_SYSTEM_STEP_ICON = VWImageLoader.createImageIcon("systemstep_st.gif").getImage();
    protected static final Image SYSTEM_STEP_ICON = VWImageLoader.createImageIcon("systemstep_f.gif").getImage();
    protected static final Image LAUNCH_STEP_ICON = VWImageLoader.createImageIcon("launchstep_f.gif").getImage();
    protected static final Image ROUTE_ICON = VWImageLoader.createImageIcon("route_print.gif").getImage();
    protected static final int FIELD_NAME_COLUMN_SZ = 31;
    protected static final int FIELD_TYPE_COLUMN_SZ = 15;
    protected static final int FIELD_MODE_COLUMN_SZ = 10;
    protected static final int FIELD_REQUIRED_COLUMN_SZ = 10;
    protected VWMap m_map = null;
    protected VWMapNode m_mapNode = null;
    protected Image m_stepImageIcon = null;
    private int m_nStepType = -1;
    private boolean m_bPrintAllInformation = true;

    public VWPrintableStepProperty(VWMapNode mapNode, Graphics g, VWMap map, VWPrinter printer, boolean bPrintAll) {
        super(g, printer);
        this.m_map = map;
        this.m_mapNode = mapNode;
        this.m_stepImageIcon = this.getImage(mapNode);
        this.m_nStepType = VWStepUtils.getStepType(this.m_mapNode);
        this.m_bPrintAllInformation = bPrintAll;
    }

    protected void renderPage(Graphics2D g2, PageFormat pf, int idx) throws PrinterException {
        Point p = new Point(0, 0);
        ArrayList page = this.getPage(idx - this.m_startingPage);
        for (String line : page) {
            if (VWStringUtils.compare(line, VWResource.s_stepProperties) == 0) {
                String sTitle = "";
                switch (this.m_nStepType) {
                    case 0: {
                        sTitle = VWResource.s_propertyLaunchStep;
                        break;
                    }
                    case 1: {
                        sTitle = VWResource.s_propertyUserStep;
                        break;
                    }
                    case 2: {
                        sTitle = VWResource.s_propertyStartUserStep;
                        break;
                    }
                    case 3: {
                        sTitle = VWResource.s_propertyQueueStep;
                        break;
                    }
                    case 4: {
                        sTitle = VWResource.s_propertyStartQueueStep;
                        break;
                    }
                    case 5: {
                        sTitle = VWResource.s_propertyUnassignedGeneralStep;
                        break;
                    }
                    case 6: {
                        sTitle = VWResource.s_propertyStartUnassignedGeneralStep;
                        break;
                    }
                    case 7: {
                        sTitle = VWResource.s_propertyGeneralStep;
                        break;
                    }
                    case 8: {
                        sTitle = VWResource.s_propertyStartGeneralStep;
                        break;
                    }
                    case 9: {
                        sTitle = VWResource.s_propertySubmapStep;
                        break;
                    }
                    case 10: {
                        sTitle = VWResource.s_propertyStartSubmapStep;
                        break;
                    }
                    case 11: {
                        sTitle = VWResource.s_propertySystemStep;
                        break;
                    }
                    case 12: {
                        sTitle = VWResource.s_propertyStartSystemStep;
                        break;
                    }
                    case 13: {
                        sTitle = VWResource.s_propertyComponentStep;
                        break;
                    }
                    case 14: {
                        sTitle = VWResource.s_propertyStartComponentStep;
                    }
                }
                this.printTitleLine(this.m_stepImageIcon, sTitle, p);
                continue;
            }
            if (line.equals(VWResource.s_routeProperties)) {
                this.printTitleLine(ROUTE_ICON, VWResource.s_routeProperties, p);
                continue;
            }
            if (line.startsWith("[[FOOTER]]")) {
                String footer = line.substring("[[FOOTER]]".length());
                this.printFooterLine(footer);
                continue;
            }
            this.printTextLine(line, p);
        }
    }

    protected void repaginate(PageFormat pf) {
        switch (this.m_nStepType) {
            case 0: {
                this.repaginateStep(pf, true);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.repaginateStep(pf, false);
                break;
            }
            case 13: 
            case 14: {
                this.repaginateComponentStep(pf);
                break;
            }
            case 9: 
            case 10: {
                this.repaginateSubMapStep(pf);
                break;
            }
            case 11: 
            case 12: {
                this.repaginateSystemStep(pf);
            }
        }
    }

    protected void repaginateStep(PageFormat pf, boolean bLaunchStep) {
        try {
            this.m_ImageableHeight = (int)pf.getImageableHeight();
            this.m_ImageableWidth = (int)pf.getImageableWidth();
            String aLine = "";
            this.newChapter(this.m_mapNode.getName());
            this.appendTitleLine(VWResource.s_stepProperties);
            aLine = VWResource.s_colon.toString(VWResource.s_name) + this.m_mapNode.getName();
            this.appendTextLine(aLine, 0, false);
            this.printGeneralInfo();
            if (this.m_bPrintAllInformation) {
                this.printParameters();
                this.printAssignments(bLaunchStep);
                this.printAttributes();
                this.printRules();
                this.printRouting();
            }
            this.flushLastPage();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void repaginateComponentStep(PageFormat pf) {
        try {
            this.m_ImageableHeight = (int)pf.getImageableHeight();
            this.m_ImageableWidth = (int)pf.getImageableWidth();
            String aLine = "";
            this.appendTitleLine(VWResource.s_stepProperties);
            aLine = VWResource.s_colon.toString(VWResource.s_name) + this.m_mapNode.getName();
            this.appendTextLine(aLine, 0, false);
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_general), 0, false);
            aLine = this.m_mapNode.getDescription();
            if (aLine != null && aLine.length() > 0) {
                this.appendTextLine(VWResource.s_descriptionColon, 1, false);
                StringTokenizer st = new StringTokenizer(aLine, "\n");
                while (st.hasMoreTokens()) {
                    this.appendTextLine(st.nextToken(), 2, true);
                }
                this.appendBlankline();
            } else {
                this.appendTextLine(VWResource.s_descriptionColon + " " + VWResource.s_none, 1, false);
            }
            if (this.m_bPrintAllInformation) {
                if (this.m_mapNode instanceof VWCompoundStepDefinition) {
                    VWInstructionDefinition[] instructionDefs = ((VWCompoundStepDefinition)this.m_mapNode).getInstructions();
                    if (instructionDefs != null && instructionDefs.length > 0) {
                        boolean bHasOperation = false;
                        for (int i = 0; i < instructionDefs.length; ++i) {
                            VWParameterDefinition[] parameterDefs;
                            VWOperationDefinition operationDef;
                            VWQueueDefinition queueDef;
                            if (!(instructionDefs[i] instanceof VWSimpleInstruction) || instructionDefs[i].getAction() != 23) continue;
                            if (!bHasOperation) {
                                bHasOperation = true;
                                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operations), 1, false);
                            }
                            String operationName = VWInstruction.ExecuteInstructionGetOperationName(instructionDefs[i]);
                            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + operationName, 2, false);
                            String componentQueueName = VWInstruction.ExecuteInstructionGetQueueName(instructionDefs[i]);
                            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_component) + " " + componentQueueName, 2, false);
                            this.appendTextLine(VWResource.s_parametersColon, 2, false);
                            VWQueue queue = VWDefaultSessionProxy.getQueue(componentQueueName);
                            if (queue != null && (queueDef = queue.fetchQueueDefinition()) != null && (operationDef = queueDef.getOperation(operationName)) != null && (parameterDefs = operationDef.getParameterDefinitions()) != null && parameterDefs.length > 0) {
                                String[] parameterValues = VWInstruction.ExecuteInstructionGetParameterList(instructionDefs[i]);
                                for (int j = 0; j < parameterDefs.length; ++j) {
                                    String name = parameterDefs[j].getName();
                                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + name, 3, false);
                                    int nType = parameterDefs[j].getDataType();
                                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_type) + " " + VWFieldType.getLocalizedString(nType), 3, false);
                                    int nMode = parameterDefs[j].getMode();
                                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_mode) + " " + VWModeType.getLocalizedString(nMode), 3, false);
                                    String value = VWResource.s_none;
                                    if (j < parameterValues.length) {
                                        value = parameterValues[j];
                                    }
                                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_value) + " " + value, 3, false);
                                    if (j >= parameterDefs.length - 1) continue;
                                    this.appendBlankline();
                                }
                            }
                            if (i >= instructionDefs.length - 1) continue;
                            this.appendBlankline();
                        }
                        if (!bHasOperation) {
                            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operations) + " " + VWResource.s_none, 1, false);
                        }
                    } else {
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operations) + " " + VWResource.s_none, 1, false);
                    }
                }
                this.printAttributes();
                this.printRules();
                this.printRouting();
            }
            this.flushLastPage();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void repaginateSubMapStep(PageFormat pf) {
        try {
            this.m_ImageableHeight = (int)pf.getImageableHeight();
            this.m_ImageableWidth = (int)pf.getImageableWidth();
            String aLine = "";
            this.appendTitleLine(VWResource.s_stepProperties);
            aLine = VWResource.s_colon.toString(VWResource.s_name) + this.m_mapNode.getName();
            this.appendTextLine(aLine, 0, false);
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_general), 0, false);
            aLine = this.m_mapNode.getDescription();
            if (aLine != null && aLine.length() > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_instructions), 1, false);
                StringTokenizer st = new StringTokenizer(aLine, "\n");
                while (st.hasMoreTokens()) {
                    this.appendTextLine(st.nextToken(), 2, true);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_instructions) + VWResource.s_none, 1, false);
            }
            aLine = VWStepUtils.getCalledMapName(this.m_mapNode);
            if (aLine != null && aLine.length() > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_submap) + aLine, 1, false);
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_submap) + VWResource.s_none, 1, false);
            }
            if (this.m_bPrintAllInformation) {
                this.printAttributes();
                this.printRules();
                this.printRouting();
            }
            this.flushLastPage();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void repaginateSystemStep(PageFormat pf) {
        try {
            this.m_ImageableHeight = (int)pf.getImageableHeight();
            this.m_ImageableWidth = (int)pf.getImageableWidth();
            String aLine = "";
            this.newChapter(this.m_mapNode.getName());
            this.appendTitleLine(VWResource.s_stepProperties);
            aLine = VWResource.s_colon.toString(VWResource.s_name) + this.m_mapNode.getName();
            this.appendTextLine(aLine, 0, false);
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_general), 0, false);
            aLine = this.m_mapNode.getDescription();
            if (aLine != null && aLine.length() > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_instructions), 1, false);
                StringTokenizer st = new StringTokenizer(aLine, "\n");
                while (st.hasMoreTokens()) {
                    this.appendTextLine(st.nextToken(), 2, true);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_instructions) + VWResource.s_none, 1, false);
            }
            if (this.m_bPrintAllInformation) {
                this.printSystemStepFunctions();
                this.printAttributes();
                this.printRules();
                this.printRouting();
            }
            this.flushLastPage();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Image getImage(VWMapNode mapNode) {
        Image image = null;
        int stepType = VWStepUtils.getStepType(mapNode);
        boolean bIsStartStep = VWStepUtils.isStartStep(stepType);
        String iconName = VWStepUtils.getIconName(mapNode);
        if (iconName != null) {
            iconName = bIsStartStep ? iconName + "_st.gif" : iconName + "_f.gif";
            ClassLoader externalClassLoader = null;
            URL imageURL = null;
            if (this.m_vwPrinter != null) {
                externalClassLoader = this.m_vwPrinter.getExternalClassLoader();
            }
            if (externalClassLoader != null) {
                imageURL = externalClassLoader.getResource(iconName);
            }
            if (imageURL != null) {
                ImageIcon imageIcon = new ImageIcon(imageURL);
                image = imageIcon.getImage();
            }
        }
        if (image == null) {
            switch (stepType) {
                case 0: {
                    image = LAUNCH_STEP_ICON;
                    break;
                }
                case 1: {
                    image = USER_STEP_ICON;
                    break;
                }
                case 2: {
                    image = START_USER_STEP_ICON;
                    break;
                }
                case 3: {
                    image = QUEUE_STEP_ICON;
                    break;
                }
                case 4: {
                    image = START_QUEUE_STEP_ICON;
                    break;
                }
                case 5: 
                case 7: {
                    image = DUMMY_STEP_ICON;
                    break;
                }
                case 6: 
                case 8: {
                    image = START_DUMMY_STEP_ICON;
                    break;
                }
                case 9: {
                    image = CALL_STEP_ICON;
                    break;
                }
                case 10: {
                    image = START_CALL_STEP_ICON;
                    break;
                }
                case 11: {
                    image = SYSTEM_STEP_ICON;
                    break;
                }
                case 12: {
                    image = START_SYSTEM_STEP_ICON;
                    break;
                }
                case 13: {
                    image = COMPONENT_STEP_ICON;
                    break;
                }
                case 14: {
                    image = START_COMPONENT_STEP_ICON;
                    break;
                }
                default: {
                    image = DUMMY_STEP_ICON;
                }
            }
        }
        return image;
    }

    private void printGeneralInfo() throws Exception {
        StringTokenizer st;
        String aLine = "";
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_general), 0, false);
        aLine = this.m_mapNode.getDocumentation();
        if (aLine != null && aLine.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_description), 1, false);
            st = new StringTokenizer(aLine, "\n");
            while (st.hasMoreTokens()) {
                this.appendTextLine(st.nextToken(), 2, true);
            }
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_description) + VWResource.s_none, 1, false);
        }
        aLine = this.m_mapNode.getDescription();
        if (aLine != null && aLine.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_instructions), 1, false);
            st = new StringTokenizer(aLine, "\n");
            while (st.hasMoreTokens()) {
                this.appendTextLine(st.nextToken(), 2, true);
            }
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_instructions) + VWResource.s_none, 1, false);
        }
        if (this.m_bPrintAllInformation && this.m_mapNode instanceof VWStepDefinition) {
            String sRequestedInterface;
            VWStepDefinition stepDef = (VWStepDefinition)this.m_mapNode;
            if (!this.m_map.isMainMap() || this.m_mapNode.getStepId() > 0) {
                aLine = stepDef.getQueueName();
                if (aLine == null || aLine.length() < 1) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_workQueue) + VWResource.s_none, 1, false);
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_workQueue) + aLine, 1, false);
                }
                VWParticipant[] participants = stepDef.getParticipants();
                if (participants == null) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_participants) + VWResource.s_none, 1, false);
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_participants), 1, false);
                    String sParticipants = null;
                    for (int i = 0; i < participants.length; ++i) {
                        sParticipants = sParticipants == null ? participants[i].getParticipantName() : sParticipants + ", " + participants[i].getParticipantName();
                    }
                    this.appendTextLine(sParticipants, 2, true);
                }
                if (stepDef.getIgnoreInvalidUsers()) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_ignoreMissingParticipants) + VWResource.s_true, 1, false);
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_ignoreMissingParticipants) + VWResource.s_false, 1, false);
                }
                this.appendTextLine(VWResource.s_participantPrivileges, 1, false);
                aLine = stepDef.getCanReassign() ? VWResource.s_colon.toString(VWResource.s_allowReassign) + VWResource.s_yes : VWResource.s_colon.toString(VWResource.s_allowReassign) + VWResource.s_no;
                this.appendTextLine(aLine, 2, true);
                aLine = stepDef.getCanViewStatus() ? VWResource.s_colon.toString(VWResource.s_allowViewStatus) + VWResource.s_yes : VWResource.s_colon.toString(VWResource.s_allowViewStatus) + VWResource.s_no;
                this.appendTextLine(aLine, 2, true);
                aLine = stepDef.getCanViewHistory() ? VWResource.s_colon.toString(VWResource.s_allowViewHistory) + VWResource.s_yes : VWResource.s_colon.toString(VWResource.s_allowViewHistory) + VWResource.s_no;
                this.appendTextLine(aLine, 2, true);
                if (this.m_mapNode.getStepId() > 0) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_deadline), 1, false);
                    long minutes = stepDef.getDeadline();
                    if (minutes <= 0L) {
                        String deadlineExp = stepDef.getDeadlineExpr();
                        aLine = VWResource.s_colon.toString(VWResource.s_deadlineWithin) + (deadlineExp != null && deadlineExp.length() > 0 ? deadlineExp : VWResource.s_none);
                    } else {
                        aLine = VWResource.s_colon.toString(VWResource.s_deadlineWithin) + this.convertTime(minutes);
                    }
                    this.appendTextLine(aLine, 2, false);
                    long reminder = stepDef.getReminder();
                    aLine = reminder <= 0L ? VWResource.s_colon.toString(VWResource.s_sendReminderBeforeDeadline) + VWResource.s_none : VWResource.s_colon.toString(VWResource.s_sendReminderBeforeDeadline) + this.convertTime(reminder);
                    this.appendTextLine(aLine, 2, false);
                    String strDeadlineSubMap = stepDef.getDeadlineMap();
                    if (strDeadlineSubMap != null && strDeadlineSubMap.length() > 0) {
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_deadlineSubmap) + strDeadlineSubMap, 2, false);
                    } else {
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_deadlineSubmap) + VWResource.s_none, 2, false);
                    }
                }
            }
            if ((sRequestedInterface = stepDef.getRequestedInterface()) != null && sRequestedInterface.length() > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_stepProcessor) + sRequestedInterface, 1, false);
            }
        }
    }

    private void printParameters() throws Exception {
        VWStepDefinition stepDef;
        VWParameterDefinition[] parameters;
        if (this.m_mapNode instanceof VWStepDefinition && (parameters = (stepDef = (VWStepDefinition)this.m_mapNode).getParameterDefinitions()) != null && parameters.length > 0) {
            this.newPrintSection();
            this.appendTextLine(VWResource.s_parametersColon, 0, false);
            int ix = 0;
            for (int i = 0; i < parameters.length; ++i) {
                this.appendTextLine(Integer.toString(++ix) + ". " + parameters[i].getName(), 1, false);
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_accessRights) + VWModeType.getLocalizedString(parameters[i].getMode()), 2, false);
                String prompt = parameters[i].getDescription();
                if (prompt == null || prompt.length() < 1) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_prompt) + VWResource.s_none, 2, true);
                    continue;
                }
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_prompt) + parameters[i].getDescription(), 2, true);
            }
        }
    }

    private void printRouteProperties(VWRouteDefinition route, int nIdx) throws Exception {
        this.newPrintSection();
        this.appendTitleLine(VWResource.s_routeProperties);
        String rName = route.getName();
        if (rName == null || rName.length() < 1) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + VWResource.s_blankRouteLabel.toString(Integer.toString(nIdx + 1)), 1, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + rName, 1, true);
        }
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_routeID) + Integer.toString(route.getRouteId()), 1, true);
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_destinationStepStr) + Integer.toString(route.getDestinationStepId()), 1, true);
        String condition = route.getCondition();
        if (condition == null || condition.length() < 1) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_condition) + VWResource.s_none, 1, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_condition) + route.getCondition(), 1, true);
        }
    }

    private void printAssignments(boolean bLaunchStep) {
        if (this.m_mapNode instanceof VWStepDefinition) {
            int i;
            String[][] assignments;
            String sMilestone;
            this.newPrintSection();
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_assignments), 0, false);
            VWStepDefinition stepDef = (VWStepDefinition)this.m_mapNode;
            if (!bLaunchStep) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_beforeExecution), 1, false);
                sMilestone = stepDef.getPreMilestone();
                if (sMilestone != null && sMilestone.length() > 0) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_milestone), 2, false);
                    this.appendTextLine(sMilestone, 3, true, true);
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_milestone) + VWResource.s_none, 2, false);
                }
                assignments = stepDef.getPreAssignments();
                if (assignments != null) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_fieldAssignments) + VWResource.s_none, 2, false);
                    for (i = 0; i < assignments.length; ++i) {
                        this.appendTextLine(Integer.toString(i + 1) + ". " + VWResource.s_colon.toString(VWResource.s_name) + assignments[i][0], 3, true);
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_expression) + assignments[i][1], 3, true);
                    }
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_fieldAssignments) + VWResource.s_none, 2, false);
                }
            }
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_afterCompletion), 1, false);
            sMilestone = stepDef.getPostMilestone();
            if (sMilestone != null && sMilestone.length() > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_milestone), 2, false);
                this.appendTextLine(sMilestone, 3, true, true);
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_milestone) + VWResource.s_none, 2, false);
            }
            assignments = stepDef.getPostAssignments();
            if (assignments != null) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_fieldAssignments) + VWResource.s_none, 2, false);
                for (i = 0; i < assignments.length; ++i) {
                    this.appendTextLine(Integer.toString(i + 1) + ". " + VWResource.s_colon.toString(VWResource.s_name) + assignments[i][0], 3, true);
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_expression) + assignments[i][1], 4, true);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_fieldAssignments) + VWResource.s_none, 2, false);
            }
        }
    }

    private void printAttributes() {
        this.newPrintSection();
        try {
            int attributeCount;
            String[] attributeNames;
            VWAttributeInfo attributeInfo = this.m_mapNode.getAttributeInfo();
            if (attributeInfo != null && (attributeNames = attributeInfo.getAttributeNames()) != null && (attributeCount = attributeNames.length) > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_attributes), 0, false);
                int nSkipCount = 0;
                for (int i = 0; i < attributeCount; ++i) {
                    String name = attributeNames[i];
                    if (name.length() > 2 && name.substring(1, 2).compareTo("F_") != 0 && name.compareTo("UI_StepType") != 0) {
                        boolean isArray = attributeInfo.isFieldArray(name);
                        Object obj = attributeInfo.getFieldValue(name);
                        this.appendTextLine(i + 1 - nSkipCount + ". " + name, 1, true);
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_type) + VWFieldType.getLocalizedString(attributeInfo.getFieldType(name)), 2, false);
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_array) + (isArray ? VWResource.s_yes : VWResource.s_no), 2, false);
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_value) + this.getValueString(obj), 2, false);
                        continue;
                    }
                    ++nSkipCount;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getValueString(Object valueObj) {
        String value = "";
        if (valueObj instanceof Boolean) {
            value = ((Boolean)valueObj).toString();
        } else if (valueObj instanceof Integer) {
            value = ((Integer)valueObj).toString();
        } else if (valueObj instanceof Double) {
            value = ((Double)valueObj).toString();
        } else if (valueObj instanceof String) {
            value = (String)valueObj;
        } else if (valueObj instanceof Boolean[]) {
            value = this.booleanArrayToString((Boolean[])valueObj);
        } else if (valueObj instanceof Integer[]) {
            value = this.integerArrayToString((Integer[])valueObj);
        } else if (valueObj instanceof Double[]) {
            value = this.doubleArrayToString((Double[])valueObj);
        } else if (valueObj instanceof String[]) {
            value = this.stringArrayToString((String[])valueObj);
        }
        return value;
    }

    private String booleanArrayToString(Boolean[] array) {
        String str = "";
        str = "{";
        int count = array.length;
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                str = str + array[i].toString();
                if (i == count - 1) continue;
                str = str + ",";
            }
        }
        str = str + "}";
        return str;
    }

    private String integerArrayToString(Integer[] array) {
        String str = "";
        str = "{";
        int count = array.length;
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                str = str + array[i].toString();
                if (i == count - 1) continue;
                str = str + ",";
            }
        }
        str = str + "}";
        return str;
    }

    private String doubleArrayToString(Double[] array) {
        String str = "";
        str = "{";
        Double[] values = array;
        int count = values.length;
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                str = str + values[i].toString();
                if (i == count - 1) continue;
                str = str + ",";
            }
        }
        str = str + "}";
        return str;
    }

    private String stringArrayToString(String[] stringArray) {
        StringBuffer buffer = new StringBuffer("{");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(stringArray[i]);
        }
        buffer.append("}");
        return buffer.toString();
    }

    private void printResponse() {
        if (this.m_mapNode instanceof VWStepDefinition) {
            VWStepDefinition stepDef = (VWStepDefinition)this.m_mapNode;
            String[] responses = stepDef.getResponses();
            if (responses != null && responses.length > 0) {
                this.appendTextLine(VWResource.s_responsesColon, 1, false);
                String sResponses = null;
                for (int i = 0; i < responses.length; ++i) {
                    sResponses = sResponses == null ? responses[i] : sResponses + ", " + responses[i];
                }
                this.appendTextLine(sResponses, 2, true);
            } else {
                this.appendTextLine(VWResource.s_responsesColon + " " + VWResource.s_none, 1, false);
            }
        }
    }

    private void printInOutRoutes() throws Exception {
        int splitType;
        String aLine = null;
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_IncomingRoutingInfo), 1, false);
        aLine = this.m_mapNode.getJoinType() == 1 ? VWResource.s_collectorStepType : VWResource.s_nonCollectorStepType;
        this.appendTextLine(aLine, 2, false);
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_outgoingRouting), 1, false);
        boolean bNoRoute = false;
        VWRouteDefinition[] routes = this.m_mapNode.getNextRoutes();
        if (routes == null || routes.length <= 0) {
            bNoRoute = true;
        }
        if ((splitType = this.m_mapNode.getSplitType()) == 1) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_stepTakeRoutes) + VWResource.s_stepRouteAllTrue, 2, true, true);
        } else if (splitType == 2) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_stepTakeRoutes) + VWResource.s_stepRouteFirstTrue, 2, true, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_stepTakeRoutes) + VWResource.s_none, 2, false);
        }
        if (bNoRoute) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_evaluationOrder) + VWResource.s_none, 2, false);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_evaluationOrder), 2, false);
            String sEvaluationOrder = null;
            for (int i = 0; i < routes.length; ++i) {
                String routeName = routes[i].getName();
                if (routeName == null || routeName.length() <= 0) {
                    routeName = VWResource.s_blankRouteLabel.toString(Integer.toString(i + 1));
                }
                sEvaluationOrder = sEvaluationOrder == null ? routeName : sEvaluationOrder + ", " + routeName;
            }
            this.appendTextLine(sEvaluationOrder, 3, true, true);
        }
        if (!bNoRoute) {
            for (int i = 0; i < routes.length; ++i) {
                this.printRouteProperties(routes[i], i);
            }
        }
    }

    private void printRouting() throws Exception {
        this.newPrintSection();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_routing), 0, false);
        this.printResponse();
        this.printInOutRoutes();
    }

    private void printRules() throws Exception {
        int ix;
        String[] ruleSetNames;
        this.newPrintSection();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_rules), 0, false);
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        if (stepType != 0) {
            ruleSetNames = this.m_mapNode.getRuleSetNames(0);
            if (ruleSetNames != null && ruleSetNames.length > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_beforeExecution), 1, false);
                for (ix = 0; ix < ruleSetNames.length; ++ix) {
                    this.appendTextLine(Integer.toString(ix + 1) + ". " + ruleSetNames[ix], 2, false);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_beforeExecution) + VWResource.s_none, 1, false);
            }
        }
        if (VWStepUtils.isGeneralStep(stepType) || VWStepUtils.isStartGeneralStep(stepType)) {
            ruleSetNames = this.m_mapNode.getRuleSetNames(1);
            if (ruleSetNames != null && ruleSetNames.length > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_onSave), 1, false);
                for (ix = 0; ix < ruleSetNames.length; ++ix) {
                    this.appendTextLine(Integer.toString(ix + 1) + ". " + ruleSetNames[ix], 2, false);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_onSave) + VWResource.s_none, 1, false);
            }
        }
        if ((ruleSetNames = this.m_mapNode.getRuleSetNames(2)) != null && ruleSetNames.length > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_afterCompletion), 1, false);
            for (ix = 0; ix < ruleSetNames.length; ++ix) {
                this.appendTextLine(Integer.toString(ix + 1) + ". " + ruleSetNames[ix], 2, false);
            }
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_afterCompletion) + VWResource.s_none, 1, false);
        }
    }

    private void printSystemStepFunctions() throws Exception {
        VWCompoundStepDefinition compoundStepDef = (VWCompoundStepDefinition)this.m_mapNode;
        VWInstructionDefinition[] instructionDefs = compoundStepDef.getInstructions();
        if (instructionDefs == null) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_functions) + VWResource.s_none, 1, false);
            return;
        }
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_functions), 1, false);
        block20: for (int i = 0; i < instructionDefs.length; ++i) {
            int actionType = instructionDefs[i].getAction();
            if (actionType == 24) continue;
            this.appendTextLine(Integer.toString(i + 1) + ". " + VWFunctionStrings.getLocalizedString(actionType), 2, true);
            switch (actionType) {
                case 0: {
                    this.printAssignmentInstuction(instructionDefs[i]);
                    continue block20;
                }
                case 1: {
                    this.printBeginTimerInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 5: {
                    this.printCallInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 6: {
                    this.printCreateInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 37: {
                    this.printDBExecute(instructionDefs[i]);
                    continue block20;
                }
                case 7: {
                    this.printDelayInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 9: {
                    this.printEndTimerInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 23: {
                    continue block20;
                }
                case 38: {
                    this.printLogFunction(instructionDefs[i]);
                    continue block20;
                }
                case 24: {
                    continue block20;
                }
                case 13: {
                    this.printResumeTimerInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 14: {
                    this.printReturnInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 29: {
                    this.printRollbackCheckpointInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 16: {
                    this.printSuspendTimerInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 19: {
                    this.printWaitForConditionInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 39: {
                    this.printInvokeInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 40: {
                    this.printReceiveInstruction(instructionDefs[i]);
                    continue block20;
                }
                case 41: {
                    this.printReplyInstruction(instructionDefs[i]);
                    continue block20;
                }
            }
        }
    }

    private void printAssignmentInstuction(VWInstructionDefinition instDef) {
        String[][] assignments = VWInstruction.AssignInstructionGetAssignment(instDef);
        if (assignments == null) {
            return;
        }
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_assignments), 3, false);
        for (int i = 0; i < assignments.length; ++i) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + assignments[i][0], 4, true);
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_expression) + assignments[i][1], 5, true);
        }
    }

    private void printBeginTimerInstruction(VWInstructionDefinition instDef) {
        String strText = VWInstruction.BeginTimerInstructionGetName(instDef);
        if (strText != null && strText.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timerNameExpression) + strText, 3, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timerNameExpression) + VWResource.s_none, 3, true);
        }
        strText = VWInstruction.BeginTimerInstructionGetExpirationTime(instDef);
        if (strText != null && strText.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_expirationTime) + strText, 3, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_expirationTime) + VWResource.s_none, 3, true);
        }
        strText = VWInstruction.BeginTimerInstructionGetSubmapName(instDef);
        if (strText != null && strText.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_submap) + strText, 3, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_submap) + VWResource.s_none, 3, true);
        }
    }

    private void printCallInstruction(VWInstructionDefinition instDef) {
        String sSubmap = VWInstruction.CallInstructionGetSubmap(instDef);
        if (sSubmap != null && sSubmap.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_submap) + sSubmap, 3, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_submap) + VWResource.s_none, 3, true);
        }
    }

    private void printCreateInstruction(VWInstructionDefinition instDef) {
        String sWorkClass = VWInstruction.CreateInstructionGetWorkClass(instDef);
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_workflowName) + sWorkClass, 3, true);
        String[][] assignments = VWInstruction.CreateInstructionGetAssignments(instDef);
        if (assignments == null || assignments.length <= 0) {
            return;
        }
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_assignments), 3, false);
        for (int i = 0; i < assignments.length; ++i) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + assignments[i][0], 4, true);
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_expression) + assignments[i][1], 5, true);
        }
    }

    private void printDelayInstruction(VWInstructionDefinition instDef) {
        String sDelayExpression = VWInstruction.DelayInstructionGetTime(instDef);
        if (sDelayExpression != null && sDelayExpression.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_delayExpression) + sDelayExpression, 3, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_delayExpression) + VWResource.s_none, 3, true);
        }
    }

    private void printEndTimerInstruction(VWInstructionDefinition instDef) {
        String sEndTimer = VWInstruction.EndTimerInstructionGetTime(instDef);
        if (sEndTimer != null && sEndTimer.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timerNameExpression) + sEndTimer, 3, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timerNameExpression) + VWResource.s_none, 3, true);
        }
    }

    private void printResumeTimerInstruction(VWInstructionDefinition instDef) {
        String sResumeTimer = VWInstruction.ResumeTimerInstructionGetTime(instDef);
        if (sResumeTimer != null && sResumeTimer.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timerNameExpression) + sResumeTimer, 3, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timerNameExpression) + VWResource.s_none, 3, true);
        }
    }

    private void printReturnInstruction(VWInstructionDefinition instDef) {
        String sRetryOption = VWInstruction.ReturnInstructionGetRetryOption(instDef);
        if (sRetryOption != null && sRetryOption.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_returnExpression) + sRetryOption, 3, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_returnExpression) + VWResource.s_none, 3, true);
        }
    }

    private void printDBExecute(VWInstructionDefinition instDef) {
        String dbName = VWInstruction.DatabaseExecuteInstructionGetDatabaseName(instDef);
        if (dbName.length() > 0) {
            dbName = dbName.substring(1, dbName.length() - 1);
        }
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_databaseConnectionAlias) + dbName, 3, false);
        String storedProcName = VWInstruction.DatabaseExecuteInstructionGetStoredProcName(instDef);
        if (storedProcName.length() > 0) {
            storedProcName = storedProcName.substring(1, storedProcName.length() - 1);
        }
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_procedureName) + storedProcName, 3, false);
        String[] parameters = VWInstruction.DatabaseExecuteInstructionGetParameters(instDef);
        if (parameters != null && parameters.length > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_parameters), 3, false);
            String strParameterList = null;
            for (int i = 0; i < parameters.length; ++i) {
                strParameterList = strParameterList == null ? parameters[i] : strParameterList + ", " + parameters[i];
            }
            this.appendTextLine(strParameterList, 4, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_parameters) + VWResource.s_none, 3, false);
        }
    }

    private void printLogFunction(VWInstructionDefinition instDef) {
        String eventTypeExpression = VWInstruction.LogInstructionGetEventType(instDef);
        if (eventTypeExpression != null && eventTypeExpression.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_eventTypeExpression) + eventTypeExpression, 3, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_eventTypeExpression) + VWResource.s_none, 3, true);
        }
        String eventMessageExpression = VWInstruction.LogInstructionGetEventMessage(instDef);
        if (eventMessageExpression != null && eventMessageExpression.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_eventMessageExpression) + eventMessageExpression, 3, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_eventMessageExpression) + VWResource.s_none, 3, true);
        }
    }

    private void printRollbackCheckpointInstruction(VWInstructionDefinition instDef) {
        String redoFlag = VWInstruction.RollBackCheckPointInstructionGetReDoFlag(instDef);
        String submap = VWInstruction.RollBackCheckPointInstructionGetMap(instDef);
        String[] nonRollBackFields = VWInstruction.RollBackCheckPointInstructionGetNonRolledBackFieldList(instDef);
        if (redoFlag != null && redoFlag.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_resumeProcessingExpression) + redoFlag, 3, true, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_resumeProcessingExpression) + VWResource.s_none, 3, true);
        }
        if (submap != null && submap.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_map) + submap, 3, true, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_map) + VWResource.s_none, 3, true);
        }
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_nonRollBackFields), 3, false);
        String sNonRollbackFields = null;
        for (int i = 0; i < nonRollBackFields.length; ++i) {
            sNonRollbackFields = sNonRollbackFields == null ? nonRollBackFields[i] : sNonRollbackFields + ", " + nonRollBackFields[i];
        }
        this.appendTextLine(sNonRollbackFields, 4, true, true);
    }

    private void printSuspendTimerInstruction(VWInstructionDefinition instDef) {
        String sSuspendTimer = VWInstruction.SuspendTimerInstructionGetTime(instDef);
        if (sSuspendTimer != null && sSuspendTimer.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timerNameExpression) + sSuspendTimer, 3, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timerNameExpression) + VWResource.s_none, 3, true);
        }
    }

    private void printWaitForConditionInstruction(VWInstructionDefinition instDef) {
        String strText = null;
        VWEventDefinition[] eventDefs = VWInstruction.WaitForEventInstructionGetEvents(instDef);
        if (eventDefs != null && eventDefs.length > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_conditions), 3, false);
            for (int i = 0; i < eventDefs.length; ++i) {
                String sMap;
                String sOperator;
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_workflowName) + eventDefs[i].getWorkClassName(), 4, true, true);
                String sCondition = eventDefs[i].getValue();
                if (sCondition != null && sCondition.length() > 0) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_condition) + sCondition, 4, true, true);
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_condition) + VWResource.s_none, 4, true, true);
                }
                String[][] assignments = eventDefs[i].getAssignments();
                if (assignments != null && assignments.length > 0) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_assignments), 4, false);
                    for (int j = 0; j < assignments.length; ++j) {
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + assignments[i][0], 5, true);
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_expression) + assignments[i][1], 6, true);
                    }
                }
                if ((sOperator = eventDefs[i].getComparisonOperator()) != null && sOperator.length() > 0) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_comparisonOperator) + "\"" + sOperator + "\"", 4, true, true);
                }
                if ((sMap = eventDefs[i].getCallISName()) != null && sMap.length() > 0) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_map) + sMap, 4, true, true);
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_map) + VWResource.s_none, 4, true, true);
                }
                this.appendBlankline();
            }
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_conditions) + VWResource.s_none, 3, false);
        }
        String sTimeout = VWInstruction.WaitForEventInstructionGetTimeOut(instDef);
        if (sTimeout.equals("0")) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timeout) + VWResource.s_none, 3, false);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timeout) + sTimeout, 3, false);
        }
        strText = VWInstruction.WaitForEventInstructionGetEventNumLoc(instDef);
        if (strText != null && strText.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_conditionResultDataField) + strText, 3, true, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_conditionResultDataField) + VWResource.s_none, 3, true, true);
        }
    }

    private void printInvokeInstruction(VWInstructionDefinition instructionDef) {
        VWWebServiceParameterDefinition wsParamDef;
        int i;
        int wsParamCount;
        VWWebServiceParameterDefinition[] wsParamDefs;
        String text = null;
        VWInvokeInstruction invoke = (VWInvokeInstruction)instructionDef;
        text = invoke.getPartnerLinkName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_partnerLink) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, false);
        text = invoke.getOperationName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operation) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, false);
        text = invoke.getInputMsgName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_inputMessageName) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, false);
        text = invoke.getOutputMsgName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_outputMessageName) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, false);
        try {
            wsParamDefs = invoke.getOutGoingParameterDefinitions();
            if (wsParamDefs != null) {
                wsParamCount = wsParamDefs.length;
                if (wsParamCount > 1) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_outgoingParameters), 3, false);
                    for (i = 1; i < wsParamCount; ++i) {
                        wsParamDef = wsParamDefs[i];
                        text = wsParamDef.getName();
                        this.appendTextLine(i + ". " + (text != null && text.length() > 0 ? text : VWResource.s_none), 4, false);
                        text = VWFieldType.getLocalizedString(wsParamDef.getDataType());
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_type) + text, 5, false);
                        text = wsParamDef.getValue();
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_expression) + (text != null && text.length() > 0 ? text : VWResource.s_none), 5, true);
                    }
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_outgoingParameters) + VWResource.s_none, 3, false);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_outgoingParameters) + VWResource.s_none, 3, false);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            wsParamDefs = invoke.getInComingParameterDefinitions();
            if (wsParamDefs != null) {
                wsParamCount = wsParamDefs.length;
                if (wsParamCount > 1) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_incomingParameters), 3, false);
                    for (i = 1; i < wsParamCount; ++i) {
                        wsParamDef = wsParamDefs[i];
                        text = wsParamDef.getName();
                        this.appendTextLine(i + ". " + (text != null && text.length() > 0 ? text : VWResource.s_none), 4, false);
                        text = VWFieldType.getLocalizedString(wsParamDef.getDataType());
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_type) + text, 5, false);
                        text = wsParamDef.getValue();
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_expression) + (text != null && text.length() > 0 ? text : VWResource.s_none), 5, true);
                    }
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_incomingParameters) + VWResource.s_none, 3, false);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_incomingParameters) + VWResource.s_none, 3, false);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        text = invoke.getInputMsgExpr();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_outgoingMessage) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, true);
        text = invoke.getOutputMsgExpr();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_incomingXMLDataField) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, false);
        this.appendBlankline();
        text = invoke.getTimeoutExpr();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timeoutExpression) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, true);
        text = invoke.getTimeoutMapName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timeoutMap) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, false);
        this.appendBlankline();
        try {
            text = Boolean.toString(invoke.getUseReliableMessaging());
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_useReliableMessaging) + text, 3, true);
        }
        catch (VWException ex) {
            // empty catch block
        }
        this.appendBlankline();
        try {
            VWFaultDefinition[] faults = invoke.getFaults();
            if (faults != null) {
                int faultCount = faults.length;
                if (faultCount > 0) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_specialFaults), 3, false);
                    for (i = 0; i < faultCount; ++i) {
                        VWFaultDefinition fault = faults[i];
                        text = fault.getName();
                        this.appendTextLine(i + 1 + ". " + (text != null && text.length() > 0 ? text : VWResource.s_none), 4, false);
                        text = fault.getFaultMessage();
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xmlDataField) + (text != null && text.length() > 0 ? text : VWResource.s_none), 5, false);
                        text = fault.getFaultMapName();
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_submap) + (text != null && text.length() > 0 ? text : VWResource.s_none), 5, true);
                    }
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_specialFaults) + VWResource.s_none, 3, false);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_specialFaults) + VWResource.s_none, 3, false);
            }
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_otherFaults), 3, false);
            text = invoke.getCatchAllMessage();
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xmlDataField) + (text != null && text.length() > 0 ? text : VWResource.s_none), 4, false);
            text = invoke.getCatchAllMap();
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_submap) + (text != null && text.length() > 0 ? text : VWResource.s_none), 4, false);
        }
        catch (VWException ex) {
            // empty catch block
        }
        this.appendBlankline();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_correlationSet), 3, false);
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_incomingMessage), 4, false);
        text = invoke.getOutputCorrelationSetName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + (text != null && text.length() > 0 ? text : VWResource.s_none), 5, false);
        String[][] outputCorrelationSets = invoke.getOutputCorrelationSetProperties();
        if (outputCorrelationSets != null) {
            int count = outputCorrelationSets.length;
            if (count > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties), 5, false);
                for (i = 0; i < count; ++i) {
                    this.appendTextLine(i + 1 + ". " + outputCorrelationSets[i][0], 6, false);
                    text = outputCorrelationSets[i][1];
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xpathQueryString) + (text != null && text.length() > 0 ? text : VWResource.s_none), 7, true);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_none, 5, false);
            }
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_none, 5, false);
        }
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_outgoingMessage), 4, false);
        text = invoke.getInputCorrelationSetName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + (text != null && text.length() > 0 ? text : VWResource.s_none), 5, false);
        String[][] inputCorrelationSets = invoke.getInputCorrelationSetProperties();
        if (inputCorrelationSets != null) {
            int count = inputCorrelationSets.length;
            if (count > 0) {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties), 5, false);
                for (int i2 = 0; i2 < count; ++i2) {
                    this.appendTextLine(i2 + 1 + ". " + inputCorrelationSets[i2][0], 6, false);
                    text = inputCorrelationSets[i2][1];
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xpathQueryString) + (text != null && text.length() > 0 ? text : VWResource.s_none), 7, true);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_none, 5, false);
            }
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_none, 5, false);
        }
    }

    private void printReceiveInstruction(VWInstructionDefinition instructionDef) {
        int i;
        String text = null;
        VWReceiveInstruction receive = (VWReceiveInstruction)instructionDef;
        text = receive.getPartnerLinkName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_partnerLink) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, false);
        text = receive.getOperationName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operation) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, false);
        try {
            VWWebServiceParameterDefinition[] params = receive.getParameterDefinitions();
            if (params != null) {
                int count = params.length;
                if (count > 1) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operationParameters), 3, false);
                    for (i = 0; i < count; ++i) {
                        VWWebServiceParameterDefinition param = params[i];
                        text = param.getName();
                        this.appendTextLine(i + ". " + text, 4, true);
                        text = VWFieldType.getLocalizedString(param.getDataType());
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_type) + text, 5, true);
                        text = param.getValue();
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_expression) + (text != null && text.length() > 0 ? text : VWResource.s_none), 5, true);
                    }
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operationParameters) + VWResource.s_none, 3, false);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operationParameters) + VWResource.s_none, 3, false);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        text = receive.getMessageExpr();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_incomingXMLDataField) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, true);
        text = receive.getMessageFromSchemaName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_schema) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, true);
        text = receive.getMessageFromElementName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_element) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, true);
        this.appendBlankline();
        text = receive.getTimeoutExpr();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timeoutExpression) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, true);
        text = receive.getTimeoutMapName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_timeoutMap) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, false);
        text = receive.getAuthentication() ? VWResource.s_yes : VWResource.s_no;
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_authentication) + text, 3, false);
        String[] names = receive.getSecurityGroup();
        if (names == null) {
            this.appendTextLine(VWResource.s_acceptMessagesFrom + VWResource.s_none, 4, false);
        } else {
            this.appendTextLine(VWResource.s_acceptMessagesFrom, 4, false);
            String sNames = null;
            for (i = 0; i < names.length; ++i) {
                sNames = sNames == null ? names[i] : sNames + ", " + names[i];
            }
            this.appendTextLine(sNames, 5, true);
        }
        try {
            int i2;
            this.appendBlankline();
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_correlationSet), 3, false);
            int id = receive.getCorrelationParameterSequenceNumber();
            VWWebServiceParameterDefinition[] params = receive.getParameterDefinitions();
            if (params != null) {
                int count = params.length;
                if (count > 0) {
                    boolean found = false;
                    for (i2 = 0; i2 < count; ++i2) {
                        if (params[i2].getSequenceNumber() != id) continue;
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operationParameterContainsCorrelationSet) + params[i2].getName(), 4, false);
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operationParameterContainsCorrelationSet) + VWResource.s_none, 4, false);
                    }
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operationParameterContainsCorrelationSet) + VWResource.s_none, 4, false);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operationParameterContainsCorrelationSet) + VWResource.s_none, 4, false);
            }
            text = receive.getCorrelationValueExpression();
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_correlationExpression) + (text != null && text.length() > 0 ? text : VWResource.s_none), 4, false);
            text = receive.getCorrelationSetName();
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + (text != null && text.length() > 0 ? text : VWResource.s_none), 4, false);
            String[][] outputCorrelationSets = receive.getCorrelationSetProperties();
            if (outputCorrelationSets != null) {
                int count = outputCorrelationSets.length;
                if (count > 0) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties), 4, false);
                    for (i2 = 0; i2 < count; ++i2) {
                        this.appendTextLine(i2 + 1 + ". " + outputCorrelationSets[i2][0], 5, false);
                        text = outputCorrelationSets[i2][1];
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xpathQueryString) + (text != null && text.length() > 0 ? text : VWResource.s_none), 6, true);
                    }
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_none, 4, false);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_none, 4, false);
            }
        }
        catch (VWException ex) {
            // empty catch block
        }
    }

    private void printReplyInstruction(VWInstructionDefinition instructionDef) {
        int i;
        int count;
        String text = null;
        VWReplyInstruction reply = (VWReplyInstruction)instructionDef;
        text = reply.getPartnerLinkName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_partnerLink) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, false);
        text = reply.getOperationName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operation) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, false);
        try {
            VWWebServiceParameterDefinition[] params = reply.getParameterDefinitions();
            if (params != null) {
                count = params.length;
                if (count > 1) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operationParameters), 3, false);
                    for (i = 0; i < count; ++i) {
                        VWWebServiceParameterDefinition param = params[i];
                        text = param.getName();
                        this.appendTextLine(i + ". " + text, 4, true);
                        text = VWFieldType.getLocalizedString(param.getDataType());
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_type) + text, 5, true);
                        text = param.getValue();
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_expression) + (text != null && text.length() > 0 ? text : VWResource.s_none), 5, true);
                    }
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operationParameters) + VWResource.s_none, 3, false);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_operationParameters) + VWResource.s_none, 3, false);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        text = reply.getMessageExpr();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_outgoingMessage) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, true);
        text = reply.getMessageFromSchemaName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_schema) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, true);
        text = reply.getMessageFromElementName();
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_element) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, true);
        try {
            text = reply.getFaultName();
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_faultName) + (text != null && text.length() > 0 ? text : VWResource.s_none), 3, true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.appendBlankline();
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_correlationSet), 3, false);
            text = reply.getCorrelationSetName();
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + (text != null && text.length() > 0 ? text : VWResource.s_none), 4, false);
            String[][] outputCorrelationSets = reply.getCorrelationSetProperties();
            if (outputCorrelationSets != null) {
                count = outputCorrelationSets.length;
                if (count > 0) {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties), 4, false);
                    for (i = 0; i < count; ++i) {
                        this.appendTextLine(i + 1 + ". " + outputCorrelationSets[i][0], 5, false);
                        text = outputCorrelationSets[i][1];
                        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_xpathQueryString) + (text != null && text.length() > 0 ? text : VWResource.s_none), 6, true);
                    }
                } else {
                    this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_none, 4, false);
                }
            } else {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_properties) + VWResource.s_none, 4, false);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

